
/*:

@target MZ
@plugindesc 「怪盗ダブルピース」に必要なプログラムです。
@author メロウ紙芝居
@url https://meroukamisibai.com/

@help MK_JsResource.js

「怪盗ダブルピース」に必要なプログラムです。
プラグイン管理の一番下に置こう。

*/

/////////////////グローバルデータ/////////////////
var mk_managers = null;

/////////////////マネージャーデータ/////////////////

//マネージャー
function MK_Managers() {
    this.stageNumber = 0;//ステージ番号
    this.stageName = "";//ステージの名前
    this.placeGame = {//ゲームの移動先
        mapId : 0,
        x : 0,
        y : 0,
        direction : 2
    };
    this.placeOp = 0;//オープニングシナリオの移動マップid
    this.placeEnd = 0;//エンドシナリオの移動マップid
    this.placeH = 0;//エロシナリオの移動マップid
    this.score = []//ステージの最高記録達
    
    this.switches = {//スイッチid
        gamePlay : 4,//ゲーム中か
        gameScreen : 6,//ゲーム画面表示
        retry : 9,//リトライしたか
        retire : 10,//リタイアしたか
        banRetire : 19,//リタイア禁止
    }
    
}

//ステージクリア時間
MK_Managers.prototype.Score = function() {
    let check = false;
    for(let r = 0; r < this.score.length; r++){
        if(this.score[r].stage == $gameVariables.value(4)){
            if(this.score[r].score > $gameVariables.value(6)){
                this.score[r].score = $gameVariables.value(6);
                this.ScoreUpdate();
            }
            check = true;
            break;
        }
    }
    if(check == false){
        this.score.push({stage:$gameVariables.value(4), score:$gameVariables.value(6)});
        this.ScoreUpdate();
    }
};

//クリア時間更新
MK_Managers.prototype.ScoreUpdate = function() {
    const t = $gameVariables.value(6);
    const min = Math.floor(t / 60) % 60;
    const sec = t % 60;
    mk_stageSelect_game.stages[$gameVariables.value(4)].Score(0, min.padZero(2) + ":" + sec.padZero(2));
};


//----------場所移動関係----------

//ゲームの場所に移動
MK_Managers.prototype.MoveGame = function() {
    const m = this.placeGame;
    $gamePlayer.reserveTransfer(m.mapId, m.x, m.y, m.direction, 0);
    $gameMap._interpreter.setWaitMode("transfer");
};

//オープニングシナリオの場所に移動
MK_Managers.prototype.MoveOp = function() {
    $gamePlayer.reserveTransfer(this.placeOp, 0, 0, 0, 0);
    $gameMap._interpreter.setWaitMode("transfer");
};

//エンドシナリオの場所に移動
MK_Managers.prototype.MoveEnd = function() {
    $gamePlayer.reserveTransfer(this.placeEnd, 0, 0, 0, 0);
    $gameMap._interpreter.setWaitMode("transfer");
};

//エロシナリオの場所に移動
MK_Managers.prototype.MoveH = function() {
    $gamePlayer.reserveTransfer(this.placeH, 0, 0, 0, 0);
    $gameMap._interpreter.setWaitMode("transfer");
};

//----------初期設定関係----------

//ゲームのステージ番号と名前を指定
MK_Managers.prototype.StageData = function(number, name) {//番号,ステージ名
    this.stageNumber = number;
    this.stageName = name;
};

//ゲームの場所移動を指定
MK_Managers.prototype.PlaceGame = function(mapId, x, y, direction) {//マップid,x,y,向き
    this.placeGame = {mapId:mapId, x:x, y:y, direction:direction};
};

//オープニングシナリオの場所移動を指定
MK_Managers.prototype.PlaceOp = function(mapId) {//マップid
    this.placeOp = mapId;
};

//エンドシナリオの場所移動を指定
MK_Managers.prototype.PlaceEnd = function(mapId) {//マップid
    this.placeEnd = mapId;
};

//エロシナリオの場所移動を指定
MK_Managers.prototype.PlaceH = function(mapId) {//マップid
    this.placeH = mapId;
};

//場所移動先などを設定する
MK_Managers.prototype.StageSet = function(index) {//ステージ番号 
    switch(index){
        case 1 :
            this.StageData(0, "チュートリアル");
            this.PlaceGame(10,7,6,6);
            this.PlaceOp(8);
            this.PlaceEnd(11);
            break;
        case 2 :
            this.StageData(1, "ゴォウカン博物館");
            this.PlaceGame(12,6,7,6);
            this.PlaceOp(28);
            this.PlaceEnd(29);
            this.PlaceH(33);
            break;
        case 3 :
            this.StageData(2, "カラクリ木馬");
            this.PlaceGame(13,7,3,2);
            this.PlaceOp(35);
            this.PlaceEnd(36);
            this.PlaceH(37);
            break;
        case 4 :
            this.StageData(3, "無人モーモー牧場");
            this.PlaceGame(14,10,22,8);
            this.PlaceOp(38);
            this.PlaceEnd(39);
            this.PlaceH(40);
            break;
        case 5 :
            this.StageData(4, "カニバレストラン");
            this.PlaceGame(16,19,10,4);
            this.PlaceOp(41);
            this.PlaceEnd(42);
            this.PlaceH(44);
            break;
        case 6 :
            this.StageData(5, "タダノ城");
            this.PlaceGame(17,12,4,2);
            this.PlaceOp(45);
            this.PlaceEnd(46);
            this.PlaceH(47);
            break;
        case 7 :
            this.StageData(6, "ゴォウカン博物館　～再～");
            this.PlaceGame(19,12,18,8);
            this.PlaceOp(48);
            this.PlaceEnd(49);
            this.PlaceH(50);
            break;
        case 8 :
            this.StageData(7, "カラクリ木馬　～再～");
            this.PlaceGame(20,18,7,4);
            this.PlaceOp(51);
            this.PlaceEnd(52);
            this.PlaceH(53);
            break;
        case 9 :
            this.StageData(8, "無人モーモー牧場　～再～");
            this.PlaceGame(21,6,9,6);
            this.PlaceOp(54);
            this.PlaceEnd(55);
            this.PlaceH(56);
            break;
        case 10 :
            this.StageData(9, "カニバレストラン　～再～");
            this.PlaceGame(22,6,10,6);
            this.PlaceOp(57);
            this.PlaceEnd(58);
            this.PlaceH(59);
            break;
        case 11 :
            this.StageData(10, "魔王城");
            this.PlaceGame(23,15,46,8);
            this.PlaceOp(60);
            this.PlaceEnd(61);
            this.PlaceH(62);
            break;
        case 12 :
            this.PlaceOp(63);
            break;
    }
};


/////////////////ゲーム画面スプライト/////////////////

//----------ゲーム画面スプライト----------

//ゲーム画面スプライト
function Mk_Managers_Sprite_Game() {
    this.initialize(...arguments);
}

Mk_Managers_Sprite_Game.prototype = Object.create(Sprite.prototype);
Mk_Managers_Sprite_Game.prototype.constructor = Mk_Managers_Sprite_Game;

Mk_Managers_Sprite_Game.prototype.initialize = function() {
    Sprite.prototype.initialize.call(this);
    this.bitmap = ImageManager.loadPicture("g_gamen");
};

Mk_Managers_Sprite_Game.prototype.update = function() {
    Sprite.prototype.update.call(this);
    if($gameSwitches.value(mk_managers.switches.gameScreen)){
        this.visible = true;
    }else{
        this.visible = false;
    }
};

//----------ゲーム画面テキストスプライト----------

//ゲーム画面テキストスプライト
function Mk_Managers_Sprite_Text() {
    this.initialize(...arguments);
}

Mk_Managers_Sprite_Text.prototype = Object.create(Sprite.prototype);
Mk_Managers_Sprite_Text.prototype.constructor = Mk_Managers_Sprite_Text;

Mk_Managers_Sprite_Text.prototype.initialize = function() {
    Sprite.prototype.initialize.call(this);
    this.bitmap = new Bitmap(816, 80);
    this.bitmap.outlineColor = "rgba(0, 100, 0, 1)";
    this.bitmap.textColor = "rgba(130, 255, 130, 1)";
};

Mk_Managers_Sprite_Text.prototype.update = function() {
    Sprite.prototype.update.call(this);
    if($gameSwitches.value(mk_managers.switches.gameScreen)){
        this.visible = true;
        const text1 = "ステージ" + mk_managers.stageNumber;
        const text2 = mk_managers.stageName;
        this.bitmap.clear();
        
        this.bitmap.fontBold = false;
        this.bitmap.fontSize = 40;
        this.bitmap.outlineWidth = 5;
        this.bitmap.drawText(text1, 20, 0, 200, 80, "left");
        
        this.bitmap.fontBold = true;
        this.bitmap.fontSize = 50;
        this.bitmap.outlineWidth = 6;
        this.bitmap.drawText(text2, 250, 0, 460, 80, "left");
    }else{
        this.visible = false;
    }
};


(function() {
    
    /////////////////元々オブジェクト/////////////////
    
    //----------ゲーム関係----------
    
    //スクロール横位置
    Game_Player.prototype.centerX = function() {
        return ($gameMap.screenTileX() - 1) / 1.6;//2から1.6に変更
    };
    
    //----------セーブ関係----------
    
    //ゲーム開始時作成データ
    const _DataManager_createGameObjects = DataManager.createGameObjects;
    DataManager.createGameObjects = function() {
        _DataManager_createGameObjects.apply(this, arguments);
        mk_managers = new MK_Managers();
    };
    
    //セーブ
    const _DataManager_makeSaveContents = DataManager.makeSaveContents;
    DataManager.makeSaveContents = function() {
        let contents = _DataManager_makeSaveContents.apply(this, arguments);
        contents.mk_managers = mk_managers;
        return contents;
    };
    
    //ロード
    const _DataManager_extractSaveContents = DataManager.extractSaveContents;
    DataManager.extractSaveContents = function(contents) {
        _DataManager_extractSaveContents.apply(this, arguments);
        mk_managers = contents.mk_managers;
    };
    
    //----------メニューシーン----------
    
    Scene_Menu.prototype.create = function() {
        Scene_MenuBase.prototype.create.call(this);
        this.createCommandWindow();
        //this.createGoldWindow();封印
        //this.createStatusWindow();封印
    };
    
    Scene_Menu.prototype.start = function() {
        Scene_MenuBase.prototype.start.call(this);
        //this._statusWindow.refresh();封印
    };
    
    //いろいろ変更
    Scene_Menu.prototype.createCommandWindow = function() {
        const rect = new Rectangle(112, 400, 600, this.calcWindowHeight(1, true));
        const commandWindow = new Window_MenuCommand(rect);
        commandWindow.setHandler('retry',   this.MK_CommandRetry.bind(this));
        commandWindow.setHandler('retire',   this.MK_CommandRetire.bind(this));
        commandWindow.setHandler('options',   this.commandOptions.bind(this));
        commandWindow.setHandler('gameEnd',   this.MK_CommandToTitle.bind(this));
        commandWindow.setHandler('cancel',    this.popScene.bind(this));
        this.addWindow(commandWindow);
        this._commandWindow = commandWindow;
    };
    
    Scene_Menu.prototype.MK_CommandToTitle = function() {
        this.fadeOutAll();
        SceneManager.goto(Scene_Title);
    };
    
    Scene_Menu.prototype.MK_CommandRetry = function() {
        $gameSwitches.setValue(mk_managers.switches.gamePlay, false);
        $gameSwitches.setValue(mk_managers.switches.retry, true);
        this.popScene();
    };
    
    Scene_Menu.prototype.MK_CommandRetire = function() {
        $gameSwitches.setValue(mk_managers.switches.gamePlay, false);
        $gameSwitches.setValue(mk_managers.switches.retire, true);
        this.popScene();
    };
    
    //----------オプションシーン----------
    
    Scene_Options.prototype.maxCommands = function() {
        return 5;
    };
    
    //----------ベーススプライト----------
    
    const _Spriteset_Base_createUpperLayer = Spriteset_Base.prototype.createUpperLayer;
    Spriteset_Base.prototype.createUpperLayer = function() {
        this.mk_managers_game = new Mk_Managers_Sprite_Game();
        this.addChild(this.mk_managers_game);
        this.mk_managers_text = new Mk_Managers_Sprite_Text();
        this.addChild(this.mk_managers_text);
        _Spriteset_Base_createUpperLayer.apply(this, arguments);
    };
    
    //----------タイマースプライト----------
    
    Sprite_Timer.prototype.createBitmap = function() {
        this.bitmap = new Bitmap(380, 60);
        this.bitmap.fontSize = 45;
        this.bitmap.outlineWidth = 5;
        this.bitmap.outlineColor = "rgba(0, 100, 0, 1)";
        this.bitmap.textColor = "rgba(130, 255, 130, 1)";
    };
    
    Sprite_Timer.prototype.timerText = function() {
        const min = Math.floor(this._seconds / 60) % 60;
        const sec = this._seconds % 60;
        return "Time " + min.padZero(2) + ":" + sec.padZero(2);
    };
    
    Sprite_Timer.prototype.updatePosition = function() {
        this.x = 460;
        this.y = 565;
    };
    
    //----------メニューウィンドウ----------
    
    Window_MenuCommand.prototype.maxCols = function() {
        if($gameSwitches.value(11)){
            return 4;
        }else{
            return 3;
        }    
    };
    
    Window_MenuCommand.prototype.itemTextAlign = function() {
        return 'center';
    };
    
    //いろいろ変更
    Window_MenuCommand.prototype.makeCommandList = function() {
        const banRetire = ($gameSwitches.value(mk_managers.switches.banRetire) == false) ? true : false;
        if($gameSwitches.value(11)){
            this.addCommand("再開", 'cancel', true);
            this.addCommand("リトライ", 'retry', true);
            this.addCommand(TextManager.options, 'options', true);
            this.addCommand("リタイア", 'retire', banRetire);
        }else{
            this.addCommand("戻る", 'cancel', true);
            this.addCommand(TextManager.options, 'options', true);
            this.addCommand(TextManager.gameEnd, 'gameEnd', true);
        }
    };
    
    //----------オプションウィンドウ----------
    
    Window_Options.prototype.addGeneralOptions = function() {
        //this.addCommand(TextManager.alwaysDash, "alwaysDash");封印
        //this.addCommand(TextManager.commandRemember, "commandRemember");封印
        this.addCommand(TextManager.touchUI, "touchUI");
    };

})();
